#include <p30fxxxx.h>
#include <spi.h>

/********************************************************************
*     Function Name : WriteSPI2                                     *
*     Description   : This routine writes a single byte/word to     * 
*                     the SPI bus.                                  *
*     Parameters    : Single data byte/word for SPI bus             *
*     Return Value  : None                                          *
********************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

void WriteSPI2(unsigned int data_out)
{   
    if (SPI2CONbits.MODE16)           /* word write */
        SPI2BUF = data_out;
    else 
        SPI2BUF = data_out & 0xff;	  /*  byte write  */
}

#endif
